import React from 'react';
import StyledButton from 'components/StyledButton';
import downloadSignError from 'resources/images/download-sign-error.svg';
import useStyles from './styles';

type Props = {
    strings: object,
    onRetry: () => {}
};

function DownloadFailedScreen({ strings, onRetry }: Props) {
    const classes = useStyles();
    return (
        <div className={classes.downloadingUpdateContainer}>
            <img
                className={classes.updateAvailableIcon}
                src={downloadSignError}
                alt="Download error icon"
            />
            <div className={classes.updateAvailableTitle}>
                {strings.update_application_error}
            </div>
            <div className={classes.updateAvailableSubtitle}>
                {strings.update_application_error_descrition}
            </div>
            <StyledButton variant="contained" btnSize="big" onClick={onRetry}>
                {strings.general_button_retry}
            </StyledButton>
        </div>
    );
}

export default DownloadFailedScreen;
